"""
This function defines a dictionary of variables.
The value for each entry of the dictionary is the text which corresponds to
a function call which will be used to extract the variable.

For details of the function calls themselves, look at the 'varsearch.py'
file where these functions are defined.
"""

from _spice_path import spice_path


def vardict():
    vardict={}
    vardict['alat']="_2darrayval(spiceref,'" + spice_path + "\\Triple_axis\\globals\\ub_matrix_globals.vi','Lattice Parameters',0,0)"
    vardict['blat']="_2darrayval(spiceref,'" + spice_path + "\\Triple_axis\\globals\\ub_matrix_globals.vi','Lattice Parameters',1,0)"
    vardict['clat']="_2darrayval(spiceref,'" + spice_path + "\\Triple_axis\\globals\\ub_matrix_globals.vi','Lattice Parameters',2,0)"
    vardict['alpha']="_2darrayval(spiceref,'" + spice_path + "\\Triple_axis\\globals\\ub_matrix_globals.vi','Lattice Parameters',0,1)"
    vardict['beta']="_2darrayval(spiceref,'" + spice_path + "\\Triple_axis\\globals\\ub_matrix_globals.vi','Lattice Parameters',1,1)"
    vardict['gamma']="_2darrayval(spiceref,'" + spice_path + "\\Triple_axis\\globals\\ub_matrix_globals.vi','Lattice Parameters',2,1)"
    vardict['gamma']="_singlevalue(spiceref,'" + spice_path + "\\Triple_axis\\globals\\ub_matrix_globals.vi','UB matrix')"
    vardict['motornames']="_singlevalue(spiceref,'" + spice_path + "\\common\\globals\\motor_globals.vi','Motor Name')"
    vardict['motoralias']="_singlevalue(spiceref,'" + spice_path + "\\common\\globals\\motor_globals.vi','Motor Alias')"
    vardict['motorpositions']="_singlevalue(spiceref,'" + spice_path + "\\common\\globals\\motor_globals.vi','Motor Positions')"
    vardict['motorupperlimits']="_singlevalue(spiceref,'" + spice_path + "\\common\\globals\\motor_globals.vi','User Upper Limit')"
    vardict['motorlowerlimits']="_singlevalue(spiceref,'" + spice_path + "\\common\\globals\\motor_globals.vi','User Lower Limit')"
    vardict['motorzeros']="_singlevalue(spiceref,'" + spice_path + "\\common\\globals\\motor_globals.vi','Motor Zeros')"
    vardict['motortolerance']="_singlevalue(spiceref,'" + spice_path + "\\common\\globals\\motor_globals.vi','Motor Tolerance')"
    vardict['emode']="_singlevalue(spiceref,'" + spice_path + "\\Triple_axis\\globals\\Tas_instrument_globals.vi','Ei/Ef mode')"
    vardict['fixed_energy']="_singlevalue(spiceref,'" + spice_path + "\\Triple_axis\\globals\\Tas_instrument_globals.vi','Fixed Energy (meV)')"
    vardict['plusminus']="_singlevalue(spiceref,'" + spice_path + "\\Triple_axis\\globals\\Tas_instrument_globals.vi','PlusMinus')"
    vardict['collimation']="_singlevalue(spiceref,'" + spice_path + "\\Triple_axis\\globals\\Tas_instrument_globals.vi','Collimation (minutes)')"
    vardict['dspace_mono']="_singlevalue(spiceref,'" + spice_path + "\\Triple_axis\\globals\\Tas_instrument_globals.vi','Monochromator d-spacing')"
    vardict['dspace_anal']="_singlevalue(spiceref,'" + spice_path + "\\Triple_axis\\globals\\Tas_instrument_globals.vi','Analyzer d-spacing')"
    vardict['autofocus']="_singlevalue(spiceref,'" + spice_path + "\\Triple_axis\\globals\\Tas_instrument_globals.vi','Monochromator AutoFocus')"
    return vardict
